import ExpandMoreIcon from "@mui/icons-material/ExpandMore";
import { AccordionSummary } from "@mui/material";
import { AccordionDetails } from "@mui/material";
import { Typography } from "@mui/material";
import { Accordion } from "@mui/material";
import { Grid } from "@mui/material";
import { Burbuja } from "./Burbuja";

export const Activos = ({ data }) => {
  return (
    <div>
      <Accordion defaultExpanded={true}>
        <AccordionSummary expandIcon={<ExpandMoreIcon />}>
          <Typography variant="h4">Todos</Typography>
        </AccordionSummary>
        <AccordionDetails
          sx={{ overflow: "auto", height: 352, padding: "0px" }}
        >
          <Grid container spacing={1}>
            {data.map((usr) => {
              return (
                <Grid item key={usr.usrName + usr.emoji}>
                  <Burbuja
                    usrName={usr.usrName}
                    emoji={usr.emoji}
                    isGreen={usr.isGreen}
                  />
                </Grid>
              );
            })}
          </Grid>
        </AccordionDetails>
      </Accordion>
    </div>
  );
};
