import { LinearProgress } from "@mui/material";
import { Typography } from "@mui/material";
import { Tooltip } from "@mui/material";
import { Switch } from "@mui/material";
import { Paper } from "@mui/material";
import { Grid } from "@mui/material";
import { useState } from "react";
import { RenderPregunta } from "./RenderPregunta";

export const Pregunta = ({ data }) => {
  const raw = data.raw;
  const numId = data.numId;

  const [checked, setChecked] = useState(false);

  const handleChange = (event) => {
    setChecked(event.target.checked);
  };

  return (
    <Paper elevation={0}>
      <Grid sx={{ minHeight: 250 }} container>
        <Grid item>
          <Typography gutterBottom variant="h2">
            Pregunta {numId}
          </Typography>
          <RenderPregunta raw={raw} checked={checked} />
          <Tooltip title="Mostrar respuesta">
            <Switch onChange={handleChange} />
          </Tooltip>
        </Grid>
      </Grid>
      <LinearProgress variant="determinate" value={data.time} />
    </Paper>
  );
};
