import StarIcon from "@mui/icons-material/Star";
import { Typography } from "@mui/material";
import { Paper } from "@mui/material";
import { Badge } from "@mui/material";
import { Grid } from "@mui/material";
import SvgFirst from "./medals/SvgFirst";
import SvgSecond from "./medals/SvgSecond";
import SvgThird from "./medals/SvgThird";

export const RankingItem = ({ position, usrName, score, star }) => {
  let color = "medal." + position;
  let colorStar = "medal." + position;
  star !== 0 ? (colorStar = "medal.star") : (colorStar = "background.paper");
  return (
    <Paper //tercer lugar
      variant="outlined"
      sx={{ borderColor: color, borderWidth: "4px" }}
    >
      <Grid
        container
        justifyContent="space-between"
        alignItems="center"
        spacing={2}
      >
        <Grid item>
          {position === "first" ? (
            <SvgFirst />
          ) : position === "second" ? (
            <SvgSecond />
          ) : (
            <SvgThird />
          )}
        </Grid>
        <Grid item>
          <Typography gutterBottom variant="h5">
            {usrName}
          </Typography>
          <Typography variant="h4" color={color}>
            {score}
          </Typography>
        </Grid>
        <Grid item>
          <Badge badgeContent={star} overlap="circular" color="error">
            <StarIcon sx={{ fontSize: 70, color: colorStar }} />
          </Badge>
        </Grid>
      </Grid>
    </Paper>
  );
};
