import React from "react";
import { Typography } from "@mui/material";
import { Box } from "@mui/material";

export const RenderPregunta = ({ raw, checked }) => {
  let highlighted = [];
  let color = "";
  color = checked ? "background.paper" : "primary.main";

  raw.split("<lq>").forEach((x) => {
    if (x.split("</lq>").length === 2) {
      highlighted.push(
        <Box
          key={x}
          component="span"
          sx={{
            backgroundColor: color,
            color: "primary.main",
            borderRadius: "4px",
          }}
        >
          {x.split("</lq>")[0]}
        </Box>
      );
      highlighted.push(x.split("</lq>")[1]);
    } else {
      highlighted.push(x);
    }
  });

  return <Typography variant="h4">{highlighted}</Typography>;
};
